
    // Setup Analog Ports 
    int i=0;
    int Zone1 = 1; 
    int Zone2 = 2; 
    int Zone3 = 3; 
    int Zone4 = 4; 
    int Zone5 = 5; 
    int Zone1CurrentState = 0;
    int Zone2CurrentState = 0;
    int Zone3CurrentState = 0;
    int Zone4CurrentState = 0;
    int Zone5CurrentState = 0;
    int Zone1InAlarm = 0;
    int Zone2InAlarm = 0;
    int Zone3InAlarm = 0;
    int Zone4InAlarm = 0;
    int Zone5InAlarm = 0;
    
    int relayPin6 = 6;
    int relayPin7 = 7;
    int inByte=0;
    int relay6=6;
    int relay7=7;
    int IOTrigger = 9;
    int relay6toggle = 0; // Set to Off 
    int relay7toggle = 0; // Set to Off 
    int LoopCount = 0;
    int LoopCountTrigger = 400;

    int pin = 0; 
    int tempc = 0,tempf = 0;
    int temphold = 0;
    int samples[8]; 

void setup(){  
    pinMode(relayPin6, OUTPUT);
    pinMode(relayPin7, OUTPUT);
    Serial.begin(9600); // start serial communication
}

void loop(){
        delay(110); // Must have delay for data bounce
        Zone1CurrentState = analogRead(Zone1);  
        Zone2CurrentState = analogRead(Zone2); 
        Zone3CurrentState = analogRead(Zone3); 
        Zone4CurrentState = analogRead(Zone4); 
        Zone5CurrentState = analogRead(Zone5);   
        if (Zone1CurrentState >= 1) {Zone1CurrentState = 11;} else {Zone1CurrentState = 0;}
        if (Zone2CurrentState >= 1) {Zone2CurrentState = 22;} else {Zone2CurrentState = 0;}
        if (Zone3CurrentState >= 1) {Zone3CurrentState = 33;} else {Zone3CurrentState = 0;}
        if (Zone4CurrentState >= 1) {Zone4CurrentState = 44;} else {Zone4CurrentState = 0;}
        if (Zone5CurrentState >= 1) {Zone5CurrentState = 55;} else {Zone5CurrentState = 0;}
        
        // Zone 1
       if (Zone1CurrentState == 11 & Zone1InAlarm == 0) {
         if (Zone1InAlarm == 0) {
             Zone1InAlarm = 1;
             Serial.println("Z1:Alarm");
         }
       }else if (Zone1CurrentState == 0 & Zone1InAlarm == 0) {
         if( Zone1InAlarm == 1 ) {
             Zone1InAlarm = 0;
             Serial.println("Z1:Closed");
         }
       }

        // Zone 2
       if (Zone2CurrentState == 22 & Zone2InAlarm == 0) {
         if (Zone2InAlarm == 0) {
             Zone2InAlarm = 1;
             Serial.println("Z2:Alarm");
         }
       }else if (Zone2CurrentState == 0 & Zone2InAlarm == 0) {
         if( Zone2InAlarm == 1 ) {
             Zone2InAlarm = 0;
             Serial.println("Z2:Closed");
         }
       }
       
       // Zone 3
       if (Zone3CurrentState == 33 & Zone3InAlarm == 0) {
         if (Zone3InAlarm == 0) {
             Zone3InAlarm = 1;
             Serial.println("Z3:Alarm");
         }
       }else if (Zone3CurrentState == 0 & Zone3InAlarm == 0) {
         if( Zone3InAlarm == 1 ) {
             Zone3InAlarm = 0;
             Serial.println("Z3:Closed");
         }
       }
       
       // Zone 4 
       if (Zone4CurrentState == 44 & Zone4InAlarm == 0) {
         if (Zone4InAlarm == 0) {
             Zone4InAlarm = 1;
             Serial.println("Z4:Alarm");
         }
       }else if (Zone4CurrentState == 0 & Zone4InAlarm == 0) {
         if( Zone4InAlarm == 1 ) {
             Zone4InAlarm = 0;
             Serial.println("Z4:Closed");
         }
       }
       
       // Zone 5
       if (Zone5CurrentState == 55 & Zone5InAlarm == 0) {
        // if (Zone5InAlarm == 0) {
             Zone5InAlarm = 1;
             Serial.println("Z5:Alarm");
         //}
       }else if (Zone5CurrentState == 0 and Zone5InAlarm == 1) {
        // if( Zone5InAlarm == 1 ) {
             Zone5InAlarm = 0;
             Serial.println("Z5:Closed");
        // }
       }
       
       if (LoopCount == (LoopCountTrigger/2) or LoopCount == LoopCountTrigger){
           long randNumber;
           i=0;
           char random_sec[1];
           randNumber = random(9999);
           itoa(randNumber,random_sec, 10);
        
           Serial.print("R#:");
           Serial.println(randNumber,DEC);
       }
        
       if (Serial.available()>0){
            inByte=Serial.read();
            if (inByte==54) {relay6=1;} // Input a #6 toggle relay 6
            if (inByte==55) {relay7=1;} // Input a #7 toggle relay 7
            if (inByte==84 or inByte==116) {IOTrigger=0;} // Input a T or t, Send Temp.
       }
  
       if (IOTrigger==0 or LoopCount>=LoopCountTrigger){
            for(i = 0;i<=7;i++){ // gets 8 samples of temperature
                samples[i] = ( 5.0 * analogRead(pin) * 100.0) / 1024.0;
                tempc = tempc + samples[i];
                delay(300);
            }

            tempc = tempc/8.0; // better precision
            tempf = (tempc * 9)/ 5 + 32; // converts to fahrenheit

            if (tempf!=temphold or LoopCount>=LoopCountTrigger){
                Serial.print(" T:");
                Serial.print(tempf,DEC);
                Serial.println(char(13));
                temphold=tempf;
            }
            tempc = 0;
            tempf = 0;
            IOTrigger = 9;
            LoopCount=0;
        }
       
        if (relay6 == 1) {
           if (relay6toggle==0) {
              digitalWrite(relayPin6, HIGH);
              Serial.println ("6R:On-Closed");
              relay6toggle=1;
            }else if (relay6toggle==1) {
              digitalWrite(relayPin6, LOW);
              Serial.println ("6R:Off-Open");
              relay6toggle=0;
          }
          relay6 = 0;
        }
 
        if (relay7 == 1) {
          if (relay7toggle==0) {
             digitalWrite(relayPin7, HIGH);
             Serial.println ("7R:On-Closed");
             relay7toggle=1;
           }else if (relay7toggle==1) {
            digitalWrite(relayPin7, LOW);
            Serial.println ("7R:Off-Open");
            relay7toggle=0;
          }
          relay7 = 0;
        }
        //delay(1000);
        LoopCount=LoopCount+1;
}


